<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('role_id', 'first_name', 'last_name', 'email', 'email_verified_at', 'mobile_phone_number', 'mobile_phone_number_verified_at');
    protected $visible = array('role_id', 'first_name', 'last_name', 'email', 'email_verified_at', 'mobile_phone_number', 'mobile_phone_number_verified_at');

    public function role()
    {
        return $this->hasOne('Role');
    }

    public function isWorker()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function userAbilities()
    {
        return $this->hasManyThrough('App\Models\Ability');
    }

    public function companies()
    {
        return $this->hasMany('App\Models\Company');
    }

    public function documents()
    {
        return $this->morphMany('App\Models\Document');
    }

}